k6 `v1.0.0-rc2` is here 🎉!

Continuing our commitment beyond the v1.0.0 release, we are pleased to announce a new release candidate that includes several significant changes:

- Native support for extensions in the Cloud
- New test failure control with `execution.test.fail`

## New features

### Native support for extensions in the Cloud [#4671](https://github.com/grafana/k6/pull/4671)

The new Binary Provisioning feature automatically requests and uses custom k6 binaries with the required extensions for your tests. This allows you to run scripts that use extensions without manually rebuilding k6 as it was in the past by depending on tools like `xk6`. The system caches binaries locally for efficiency, and any additional runs with the same dependencies will use the same binary and will run faster.

Binary Provisioning is available for all k6 Cloud users (free and paid plans). It is an experimental feature, it's enabled by opt-in with the feature flag `K6_BINARY_PROVISIONING=true`.

Binary provisioning is a limited set of extensions that are supported, and it's not available for the `k6 run` command that might be added in the future. However, local development is supported with the `k6 cloud --local-execution` command if a cloud token is provided by the canonical login methods.
Check out [the documentation](https://grafana.com/docs/grafana-cloud/testing/k6/author-run/use-k6-extensions) for additional details.
### Test failure control with `execution.test.fail` [#4672](https://github.com/grafana/k6/pull/4672)

The new [`execution.test.fail`](https://grafana.com/docs/k6/latest/javascript-api/k6-execution/#test-fail) function allows you to explicitly fail a test while letting it continue execution until completion. This gives you more control over test outcomes while still collecting all metrics and completing necessary cleanup tasks.

## UX improvements and enhancements

- [#4698](https://github.com/grafana/k6/pull/4698) Displays threshold values even when are not configured in `summaryTrendStats` option.
- [#4699](https://github.com/grafana/k6/pull/4699) Drops the link of the legacy k6 website from the user agent.

## Bug fixes

- [#4717](https://github.com/grafana/k6/pull/4717) Safeguards against `pressedKeys` being updated concurrently in the browser module.
- [#4665](https://github.com/grafana/k6/pull/4665) Prevents race condition between `Ended` & `Interrupted` execution states.
- [#4677](https://github.com/grafana/k6/pull/4677) Makes `secretsource` also redact `float32` and `float64` values.

## Maintenance and internal improvements

- [#4675](https://github.com/grafana/k6/pull/4675), [#4676](https://github.com/grafana/k6/pull/4676), [#4678](https://github.com/grafana/k6/pull/4678) Move several packages to `internal` as preparations for v1.0.0 stabilization
- [#4686](https://github.com/grafana/k6/pull/4686) Drops the redundant `NO_COLOR` detection.
- [#4709](https://github.com/grafana/k6/pull/4709) Fixes JS native objects override to avoid a page under the test from overwriting native JavaScript objects, like `Set` and `Map`.
- [#4726](https://github.com/grafana/k6/pull/4726) Unifies the internal/cmd.Execute methods.
- [#4703](https://github.com/grafana/k6/pull/4703) Makes wptTests run without tags or skip if repos not checkout.
- [#4701](https://github.com/grafana/k6/pull/4701) Fixes WebCrypto errors not propagating from the tests.
- [#4691](https://github.com/grafana/k6/pull/4691), [#4674](https://github.com/grafana/k6/pull/4674), [#4673](https://github.com/grafana/k6/pull/4673), [#4663](https://github.com/grafana/k6/pull/4663) Bumps the versions for `OpenTelemetry`, `grpc`, `golang/x` and `esbuild` dependencies.
- [#4691](https://github.com/grafana/k6/pull/4691) Bumps x509roots/fallback dependency for fallback certificates.
- [#4739](https://github.com/grafana/k6/pull/4739) Removes deprecated `GetLayoutMetrics.VisualViewport` CDP usage.
